// file      : xsde/cxx/version.hxx.in
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef LIBXSDE_VERSION // Note: using the version macro itself.

// The numeric version format is AAAAABBBBBCCCCCDDDE where:
//
// AAAAA - major version number
// BBBBB - minor version number
// CCCCC - bugfix version number
// DDD   - alpha / beta (DDD + 500) version number
// E     - final (0) / snapshot (1)
//
// When DDDE is not 0, 1 is subtracted from AAAAABBBBBCCCCC. For example:
//
// Version      AAAAABBBBBCCCCCDDDE
//
// 0.1.0        0000000001000000000
// 0.1.2        0000000001000020000
// 1.2.3        0000100002000030000
// 2.2.0-a.1    0000200001999990010
// 3.0.0-b.2    0000299999999995020
// 2.2.0-a.1.z  0000200001999990011
//
#define LIBXSDE_VERSION       300004000000000ULL
#define LIBXSDE_VERSION_STR   "3.4.0"
#define LIBXSDE_VERSION_ID    "3.4.0"
#define LIBXSDE_VERSION_FULL  "3.4.0"

#define LIBXSDE_VERSION_MAJOR 3
#define LIBXSDE_VERSION_MINOR 4
#define LIBXSDE_VERSION_PATCH 0

#define LIBXSDE_PRE_RELEASE   false

#define LIBXSDE_SNAPSHOT      0ULL
#define LIBXSDE_SNAPSHOT_ID   ""

// Backward compatibility macros.
//
#define XSDE_STR_VERSION LIBXSDE_VERSION_FULL

// Version format is AABBCCDD where
//
// AA - major version number
// BB - minor version number
// CC - bugfix version number
// DD - alpha / beta (DD + 50) version number
//
// When DD is not 00, 1 is subtracted from AABBCC. For example:
//
#define XSDE_INT_VERSION ((3 * 1000000L) + \
                          (4 *   10000L) + \
                          (0 *     100L) + \
                          (false \
                           ? -100 + 0 + \
                             (false ? 50 : 0) \
                           : 0))

#endif // LIBXSDE_VERSION
