// file      : xsde/cxx/parser/validating/qname.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/validating/qname.hxx>
#include <xsde/cxx/parser/validating/ncname-common.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace validating
      {
        void qname_pimpl::
        _pre ()
        {
#ifdef XSDE_EXCEPTIONS
          str_.assign ("", 0);
#else
          if (str_.assign ("", 0))
            sys_error (sys_error::no_memory);
#endif
        }

        void qname_pimpl::
        _characters (const ro_string& s)
        {
          if (str_.size () == 0)
          {
            ro_string tmp (s.data (), s.size ());

            if (trim_left (tmp) != 0)
            {
#ifdef XSDE_EXCEPTIONS
              str_.append (tmp.data (), tmp.size ());
#else
              if (str_.append (tmp.data (), tmp.size ()))
                sys_error (sys_error::no_memory);
#endif
            }
          }
          else
          {
#ifdef XSDE_EXCEPTIONS
            str_.append (s.data (), s.size ());
#else
            if (str_.append (s.data (), s.size ()))
              sys_error (sys_error::no_memory);
#endif
          }
        }

        void qname_pimpl::
        _post ()
        {
          ro_string tmp (str_.data (), str_.size ());
          ro_string::size_type size = trim_right (tmp);
          ro_string::size_type pos = tmp.find (':');

          const char* s = tmp.data ();

          if (pos != ro_string::npos)
          {
            if (bits::valid_ncname (s, pos) &&
                bits::valid_ncname (s + pos + 1, size - pos - 1))
            {
#ifdef XSDE_EXCEPTIONS
              prefix_.assign (s, pos);
              name_.assign (s + pos + 1, size - pos - 1);
#else
              if (prefix_.assign (s, pos) ||
                  name_.assign (s + pos + 1, size - pos - 1))
                sys_error (sys_error::no_memory);
#endif
            }
            else
              schema_error (schema_error::invalid_qname_value);
          }
          else
          {
            if (bits::valid_ncname (s, size))
            {
#ifdef XSDE_EXCEPTIONS
              prefix_.assign ("", 0);
              str_.truncate (size);
              name_.swap (str_);
#else
              if (prefix_.assign ("", 0))
                sys_error (sys_error::no_memory);
              else
              {
                str_.truncate (size);
                name_.swap (str_);
              }
#endif
            }
            else
              schema_error (schema_error::invalid_qname_value);
          }
        }

        qname* qname_pimpl::
        post_qname ()
        {
          qname* r = new qname ();

#ifndef XSDE_EXCEPTIONS
          if (r != 0)
          {
#endif
            r->attach_prefix (prefix_.detach ());
            r->attach_name (name_.detach ());

#ifndef XSDE_EXCEPTIONS
          }
          else
            sys_error (sys_error::no_memory);
#endif
          return r;
        }
      }
    }
  }
}
