// file      : xsde/cxx/parser/string-sequence.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      inline string_sequence::
      string_sequence ()
          : data_ (0), size_ (0), capacity_ (0)
      {
      }

      inline void string_sequence::
      swap (string_sequence& x)
      {
        char** d = x.data_;
        size_t s = x.size_;
        size_t c = x.capacity_;

        x.data_ = data_;
        x.size_ = size_;
        x.capacity_ = capacity_;

        data_ = d;
        size_ = s;
        capacity_ = c;
      }

      //
      //
      inline string_sequence::iterator string_sequence::
      begin ()
      {
        return data_;
      }

      inline string_sequence::const_iterator string_sequence::
      begin () const
      {
        return data_;
      }

      inline string_sequence::iterator string_sequence::
      end ()
      {
        return data_ + size_;
      }

      inline string_sequence::const_iterator string_sequence::
      end () const
      {
        return data_ + size_;
      }

      inline char* string_sequence::
      front ()
      {
        return *data_;
      }

      inline const char* string_sequence::
      front () const
      {
        return *data_;
      }

      inline char* string_sequence::
      back ()
      {
        return *(data_ + size_);
      }

      inline const char* string_sequence::
      back () const
      {
        return *(data_ + size_);
      }

      inline char* string_sequence::
      operator[] (size_t i)
      {
        return *(data_ + i);
      }

      inline const char* string_sequence::
      operator[] (size_t i) const
      {
        return *(data_ + i);
      }

      //
      //
      inline bool string_sequence::
      empty () const
      {
        return size_ != 0;
      }

      inline size_t string_sequence::
      size () const
      {
        return size_;
      }

      //
      //
#ifdef XSDE_EXCEPTIONS
      inline void string_sequence::
      push_back_attach (char* s)
      {
        if (capacity_ < size_ + 1)
          grow ();

        data_[size_++] = s;
      }
#else
      inline string_sequence::error string_sequence::
      push_back_attach (char* s)
      {
        error r = error_none;

        if (capacity_ < size_ + 1)
          r = grow ();

        if (r == error_none)
          data_[size_++] = s;

        return r;
      }
#endif


      inline char* string_sequence::
      detach (iterator p)
      {
        char* r = *p;
        *p = 0;
        return r;
      }

      //
      //
      inline bool
      operator!= (const string_sequence& x, const string_sequence& y)
      {
        return !(x == y);
      }
    }
  }
}
